/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DPCDCommandType;
import com.quantumdata.busmon.parser.DPCDMessage;
import com.quantumdata.busmon.parser.DPCDMessageType;

public class DPCDReplyMessage
extends DPCDMessage {
    private boolean aDataMValue = false;

    public DPCDReplyMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType) {
        super(dPCDMessageType, dPCDCommandType);
        this.aDataMValue = false;
    }

    public DPCDReplyMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, boolean bl) {
        this(dPCDMessageType, dPCDCommandType);
        this.aIsMOT = bl;
    }

    public DPCDReplyMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, byte[] byArray) {
        super(dPCDMessageType, dPCDCommandType, byArray);
        if (dPCDCommandType == DPCDCommandType.AUX_NACK && dPCDMessageType == DPCDMessageType.REPLY_TO_WRITE_REQUEST) {
            if (byArray != null) {
                this.aDataMValue = true;
            } else {
                this.aIsError = true;
            }
        }
    }

    public DPCDReplyMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, byte[] byArray, boolean bl) {
        this(dPCDMessageType, dPCDCommandType, byArray);
        this.aIsMOT = bl;
    }

    public boolean isDataMValue() {
        return this.aDataMValue;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.isNative() ? "DPCD" : "I2C Over AUX";
        stringBuffer.append("Message Type:  " + this.getMessageTypeText() + "\n");
        stringBuffer.append("Command Type:  " + this.getCommandTypeText() + "\n");
        stringBuffer.append("Direction:  " + this.getDirection() + "\n");
        stringBuffer.append("Middle of Transaction:  " + this.getMOT() + "\n");
        if (this.isDataMValue()) {
            byte by = this.getData()[0];
            stringBuffer.append("This message is a Reply NACK with an M-Value of:  " + by + "\n");
        }
        if (this.hasData()) {
            stringBuffer.append(this.getDataAsHexString());
        } else {
            stringBuffer.append("This message contains no data");
        }
        return stringBuffer.toString();
    }
}

